package gov.va.med.domain.service.messaging.encode.hl7.structure;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.v24.segment.PID;
import ca.uhn.log.HapiLogFactory;

/**
 * OMP_O09
 *
 * @author Slava Uchitel
 * @version $Id: OMP_O09.java,v 1.1.1.1 2005/05/13 19:40:43 jon.crater Exp $
 * @since MHV 2.0 <br>Mar 1, 2005
 */
public class OMP_O09 extends ca.uhn.hl7v2.model.v24.message.OMP_O09 
{ 
    /** 
	 * Creates a new OMP_O09 Group.
	 */
	public OMP_O09() {
	   super();
       try {
	      this.add(PID.class, true, false);
	      this.add(OMP_O09_ORCRXE.class, true, true);   
       } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error creating OMP_O09 - this is probably a bug in the source code generator.", e);
	   }
	}
    
    public OMP_O09_ORCRXE getORCRXE(int rep)
    {
       OMP_O09_ORCRXE ret = null;
	   try {
	      ret = (OMP_O09_ORCRXE) this.get("OMP_O09_ORCRXE", rep);
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
       return ret;
    }
    
    public PID getPID()
    {
       PID ret = null;
	   try {
	      ret = (PID) this.get("PID");
	   } catch(HL7Exception e) {
	      HapiLogFactory.getHapiLog(this.getClass()).error("Unexpected error accessing data - this is probably a bug in the source code generator.", e);
	   }
       return ret;
    }    
    
    public String er7Encode()
    {
        StringBuffer buf = new StringBuffer();
        
        return buf.toString();  
    }    
} 
